/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * (c) Copyright 1991 Christopher Fedor and Reid Simmons.  All rights reserved.
 *
 * MODULE: 
 *
 * FILE: 
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/src/basics.h,v $ 
 * $Revision: 1.19 $
 * $Date: 1996/01/05 16:30:59 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: basics.h,v $
 * Revision 1.19  1996/01/05  16:30:59  rich
 * Added windows NT port.
 *
 * Revision 1.18  1995/07/25  20:08:45  rich
 * Changes for NeXT machine (3.0).
 *
 * Revision 1.17  1995/07/06  22:08:06  rich
 * Missing directive.
 *
 * Revision 1.16  1995/07/06  21:39:26  rich
 * Fixes ported from 7.9.
 *
 * Revision 1.15  1995/07/06  21:15:40  rich
 * Solaris and Linux changes.
 *
 * Revision 1.14  1995/05/31  19:34:53  rich
 * Fixed problem with reply data being freed early from replys.
 * Initial work on getting the PC version to work.
 *
 * Revision 1.13  1995/04/21  03:53:00  rich
 * Added central commands to kill the task tree and close a module.
 * Added tcaGetContext and tcaSetContext to support connections to multiple
 * central servers.  tcaConnectModules can be called multiple times.
 * Fixed a bug in the resource limit pending.
 * Created seperate routines to print help and option messages.
 *
 * Revision 1.12  1995/04/19  14:27:36  rich
 * Fixed problems with lisp encode/decode functions.
 * Added types int32 and int16 for use where the size of the integer matters.
 *
 * Revision 1.11  1995/04/08  02:06:10  rich
 * Added waitForReplyFrom to be able to block on replies from only one
 * source.  Useful when querying for the msg info information.  Added a
 * tcaQueryCentral that only accepts input from the central server.  Fixed
 * timing problems with direct connections.
 *
 * Revision 1.10  1995/04/07  05:02:39  rich
 * Fixed GNUmakefiles to find the release directory.
 * Cleaned up libc.h file for sgi and vxworks.  Moved all system includes
 * into libc.h
 * Got direct queries to work.
 * Fixed problem in allocating/initializing generic mats.
 * The direct flag (-c) now mostly works.  Connect message has been extended to
 * indicate when direct connections are the default.
 * Problem with failures on sunOS machines.
 * Fixed problem where tcaError would not print out its message if logging had
 * not been initialized.
 * Fixed another memory problem in modVar.c.
 * Fixed problems found in by sgi cc compiler.  Many type problems.
 *
 * Revision 1.9  1995/03/30  15:42:21  rich
 * DBMALLOC works.  To use "gmake -k -w DBMALLOC=DBMALLOC install"
 * Added simple list of strings data structure that can be passed via tca
 * messages.
 * Use the string list to maintain a global variable of messages with taps.
 * Tapped messages are not sent via direct connections.
 * Implemented code to vectorize data to be sent so that it does not have
 * to be copied.  Currently, only flat, packed data structures are
 * vectored.  This can now be easily extended.
 * Changed Boolean -> BOOLEAN for consistency and to avoid conflicts with x11.
 * Fixed bug were central would try and free the "***New Module***" and
 * "*** Unkown Host***" strings when a module crashed on startup.
 * Fixed a bug reported by Jay Gowdy where the code to find the size of a
 * variable lenght array would access already freed data when called from
 * tcaFreeData.
 *
 * Revision 1.8  1995/03/28  01:14:09  rich
 * - Added ability to log data with direct connections.  Also fixed some
 * problems with global variables. It now uses broadcasts for watching variables.
 * - Added preliminary memory recovery routines to handle out of memory
 * conditions.  It currently purges items from resource queues.  Needs to
 * be tested.
 * - If the CENTRALHOST environment variable is not set, try the current
 * host.
 * - Fixed a problem with central registered messages that caused the parsed
 * formatters to be lost.
 * - Added const declarations where needed to the prototypes in tca.h.
 * - tcaGetConnections: Get the fd_set.  Needed for direct connections.
 * - Added tcaExecute and tcaExecuteWithConstraints.  Can "execute" a goal
 *   or command.
 * - tcaPreloadMessage: Preload the definition of a message from the
 *   central server.
 *
 * Revision 1.7  1995/01/18  22:39:30  rich
 * TCA 7.9: Speed improvements.
 * Use unix sockets for communication on the same machine.
 * Eliminate copying.
 * Optimize loop for arrays, especially simple, primitive arrays.
 * Optimize the buffer size.
 *
 * Revision 1.6  1994/10/25  17:09:30  reids
 * Changed the logging functions to accept variable number of arguments.
 *
 * Revision 1.5  1994/05/31  03:23:41  rich
 * Removed CFLAGS_sun4.
 * Removed cfree and bzero from mem routines.
 * Set zero wait on both sides of the pipe.  Can connect to host using inet
 * number.
 *
 * Revision 1.4  1994/04/28  16:15:10  reids
 * Changes in TCA Version 7.6:
 *  1) New functions: tcaIgnoreLogging and tcaResumeLogging
 *  2) Code for MacIntosh (MPW) version of TCA
 *
 * Revision 1.3  1993/11/21  20:17:02  rich
 * Added shared library for sun4c_411 sunos machines.
 * Added install to the makefile.
 * Fixed problems with global variables.
 *
 * Revision 1.2  1993/08/30  21:52:56  fedor
 * V7+V6+VXWORKS Everything compiles but there are initialization problems.
 *
 * Revision 1.1  1993/08/27  07:13:59  fedor
 * First Pass at V7 and V6+VXWORKS merge
 *
 * Revision 1.4  1993/07/08  05:38:00  rich
 * Added function prototypes
 *
 * Revision 1.3  1993/06/22  13:58:26  rich
 * Added makefile.depend.  Dependencies automatically generated using gcc.
 * Fixed some warnings.
 * Updated the -D<arch> flags to correspond to those generated
 * automatically by the makefile.
 * Changed system includes to the proper format "stdio.h" -> <stdio.h>.
 * This was needed so that the automatic dependency generation can
 * distinguish between "local" and system headers.  The location of the
 * system headers changes from architecture to architecture and should not
 * be included in the dependency list.
 *
 * Revision 1.2  1993/05/27  22:16:01  rich
 * Added automatic logging.
 *
 *****************************************************************************/

#ifndef INCbasics
#define INCbasics

/* GCC supports inlining of functions.*/
#if defined(__GNUC__) && !defined(__NeXT__)
#define INLINE __inline__
#else
#define INLINE
#endif

#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#if defined(THINK_C) || defined(applec) || defined(__TURBOC__) || defined(__svr4__)
#define bzero(buf, len) memset((void *)(buf), 0, (size_t)(len))

#define bcopy(from, to, len) memcpy((void *)(to), (void *)(from), (size_t)len)

#endif /* THINK_C || applec */

#define BCOPY(source, dest, length) \
memcpy \
((void *)(dest),(void *)(source),(size_t)(length))

#ifndef _WINSOCK_  /* windows already has a BOOLEAN type */
typedef int BOOLEAN;
#endif /* _WINSOCK_ */

/* A generic pointer (prints out better than "data_ptr" does in the debugger */
typedef struct {
  char *dummy;
} *value_ptr;

#ifndef MAX
#define MAX(x,y)  ((x) > (y) ? (x) : (y))
#endif

#ifndef MIN
#define MIN(x,y)  ((x) > (y) ? (y) : (x))
#endif

#ifndef NEW
#define NEW(type) (type *)tcaMalloc((unsigned int) sizeof(type))
#endif

#ifndef NEW_DB
#define NEW_DB(file,line, type) (type *)tcaDBMalloc(file,line, (unsigned int) sizeof(type))
#endif

#ifndef STREQ
#define STREQ(str1, str2) (!(strcmp((str1),(str2))))
#endif

/* the new sunos 4.1 for sun3 leaves out tolower/toupper in ctypes.h 
   this is still needed for the 4.0.3 systems */

#ifndef ABS
#define ABS(x)	  ((x) >= 0 ? (x) : -(x))
#endif


#ifndef PAUSE_MIN_DELAY
#if defined(__sgi)
#define PAUSE_MIN_DELAY() sginap(1);	/* delay 1/100 sec */
#elif defined(__TURBOC__) || defined(__svr4__)
#define PAUSE_MIN_DELAY() sleep(1);	/* delay 1 sec */
#else
#define PAUSE_MIN_DELAY() usleep(1);	/* delay 1/1000000 sec */
#endif /* SGI */
#endif

#endif /* INCbasics */
