/*
   test_do.cxx

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This tests the do interface.

*/

#include "test_do.h"
#include "scopeprobe.h"
#include "taskLib.h"
#include "sysLib.h"

#define NUM_DO 28

// Enables the do for each block
int do_Init (void)
{
  for (int i=0; i<NUM_DO; i++)
    { dout[i].EnableIO(); }
  return 0;
}

// sets the value for do
int do_Set  (int do_num, int value)
{
  return dout[do_num].SetDO(value);
}            

// gets the value from do
int do_Read  (int do_num)
{
  return dout[do_num].GetDO();
}            

// captures to stethoscope at freq
int do_Scope (int freq)
{
  int  nVal[NUM_DO];
  char name[20];
  int  n;

  if ((freq < 0) || (freq > sysClkRateGet()))
    {
      printf("freq = %d must be between 0 and %d\n", freq, sysClkRateGet());
      return -1;
    }

  for (n=0; n<NUM_DO; n++)
    {
      sprintf(name, "do:chan%d", n);
      ScopeInstallSignal(name, "boolean", &nVal[n], "int", 0);
    }

  ScopeChangeSampleRate(double(freq), 0);

  while(1)
    {
      for(n=0; n<NUM_DO; n++)
	{
	  nVal[n] = dout[n].GetDO();
	}
      ScopeCollectSignals(0);
      taskDelay(sysClkRateGet()/freq);
    }

  return 0;
}

