/*
   robot.cxx

   Mark Sibenac
   97-1-22
   Atacama Desert Trek
   Field Robotics Center


   This is the top level class that instantiates everything else.

   Call InitRobot() to install all devices and interfaces and whatever other
   modules need to be installed.

*/

#include "robot.h"
#include "vxLib.h"
#include "usrLib.h"
#include "semLib.h"
#include "logLib.h"


#define PRIORITY_ROBOT (60)
#define ROBOT_AUX_CLK_FREQ (300)

Crobot *robot; // The robot pointer instantiation

extern "C" {
  int on_exit(int);
  int RobotFun(int, int, int, int, int, int, int, int, int, int);
  int RobotISR(int);
}

int on_exit(int)
{
 printf("on_exit() Done...\n");
 return 0;
}

extern int mutexes_installed; // defined in devices/vmio/vmio10.cxx

// Kinda like main(). Should be called first.
int InitRobot()
{
  __do_global_ctors();

  InitInterfaces();
  mutexes_installed = 0; // make it false
  InitHardware();
  RegisterHardware();
  InitComponents();
  InitModules();

//  robot = new Crobot; // Create robot object

  return 0;
}

int KillRobot()
{
  printf("Killing Robot\n");

  KillModules();
  KillComponents();
  KillHardware();
  KillInterfaces();

//  kill robot;

  __do_global_dtors();

  return 0;
}

int RobotFun(int, int, int, int, int, int, int, int, int, int)
{
  SEM_ID update_sem = robot->GetUpdateSem();

  while (1)
    {
      semTake (update_sem, WAIT_FOREVER);

      robot->Cycle1();
      robot->Cycle2();
      robot->Cycle3();
    }

  return 0;
}

// This function is attached to the sysAuxClk Interrupt
int RobotISR(int)
{
  // Signal the cycles to start now
  return semGive(robot->GetUpdateSem());
}

// Constructor for Crobot
Crobot::Crobot()
{
  int tid;
  char pString[20];

  Dprintf(("Crobot::Crobot() constructing itself!!\n"));

  drivesys = new Cdrivesys();
  printf("Initializing drivesys\n");
  drivesys->Init (); // create amp objects and run servo process in background
//  drivesys->SetUpdateFreq(pid_freq, traj_freq, drive_freq);
  

  pointsys = new Cpointsys();

  

  if (!(m_SemUpdate = semBCreate (SEM_Q_FIFO, SEM_EMPTY)))
    {
      Dprintf(("Crobot::Crobot() semBCreate() was not able to allocate "
	       "memory.\n"));
      return;
    }

  sprintf(pString, "tRobot");
  if ((tid = taskNameToId(pString)) != -1) taskDelete (tid);
  taskSpawn (pString, PRIORITY_ROBOT, VX_SUPERVISOR_MODE | 
	     VX_DEALLOC_STACK | VX_FP_TASK | VX_STDIO, 20000, 
	     (FUNCPTR)RobotFun, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10);

  if (sysAuxClkConnect ((FUNCPTR)RobotISR, 0))
    {
      printf("AuxClock could not connect\n");
      return;
    }

  if (!sysAuxClkRateSet (ROBOT_AUX_CLK_FREQ))
    {
      Dprintf(("AuxClk connected at freq = %d\n", ROBOT_AUX_CLK_FREQ));
      sysAuxClkEnable();
    } else {
      printf("AuxClk could not connect at freq = %d\n", ROBOT_AUX_CLK_FREQ);
      return;
    }
}

// Destructor for Crobot
Crobot::~Crobot()
{
  sysClkDisable();

  delete pointsys;
  delete drivesys;

}

int Crobot::Cycle1 ()
{
  return 0;
}

int Crobot::Cycle2 ()
{
  return 0;
}

int Crobot::Cycle3 ()
{
  return 0;
}
