/* 
   p_gui_test.c \- Test NDDS methods for the p_gui type.

   modification history
   ------------ -------
   RTI,02apr94,gpc Written
   -------
   Author:
   ------
   Gerardo Pardo-Castellote       March 1994
 */

static char copyright_rti[] = 
"(c) Copyright, Real-Time Innovations, Inc., 1994.  All rights reserved.";

/*
DESCRIPTION:
This file is automatically generated by 'nddsgen'
Compile this file, link to   p_gui_xdr.o and p_gui.o
and NddsXDR.a to test the serialization/deserialization/print methods 
that define the NDDS type p_gui.
--------------------------------------------------------------------------- */


#include <stdlib.h> 
#include <stdio.h>

#include "NDDS.h"

#include "p_gui.h"

void main(int argc, char *argv[])
{
    p_gui src, dest;
    NDDSXDRStream nddsds;

    
    nddsds = NddsXDRStreamAlloc(NDDS_XDR_MAX_BUFFER_SIZE);
    src = (p_gui)calloc(1, sizeof(*src));

    printf("User Initialization of a p_gui\n");
    {
	/* Your initialization code goes here! */

    }
    
    /* Print the src p_gui */
    printf("p_guiPrint(src)\n");
    p_guiPrint(src);

    /* Test Serialize/Deserialize Methods */
    printf("p_guiSerialize()\n");
    if (!p_guiSerialize(nddsds, src, NDDS_DEFAULT_OPTIONS)) {
	printf("p_guiSerialize Failed\n");
	exit (0);
    }

    
    printf("p_guiDeserialize()\n");
    dest = p_guiDeserialize(NULL, nddsds);
    if (dest==NULL) {
	printf("p_guiDeserialize Failed\n");
	exit (0);
    }

    printf("After deserialization:\n");
    p_guiPrint(dest);
}
