/* mangen p_gui \- NDDS methods for p_gui type
   banner = ==========
  
   This file is derived from code automatically generated by nddsgen.

   modification history
   ------------ -------
   19a,29aug95,gpc Mofified for version 1.9
   19a,20Aug95,gpc Auto-gen code for p_guiAllocate and p_guiFree
   RTI,30may94,sas cleanup.
   RTI,02apr94,gpc Auto-generated code template written.
 */

static char copyright_rti[] = 
"(c) Copyright, Real-Time Innovations, Inc., 1994.  All rights reserved.";

/*
DESCRIPTION:
This file implements the NDDS methods required to declare a p_gui 
type to NDDS. This file was automatically generated by the 'nddsgen'
code generator from a specification of the p_gui type given in
the XDR language. See the man pages on 'nddsgen' and 'NddsXDR'.

This file was generated with the following steps:

(1) A description of the type p_gui was written in a file
named p_gui.x (NOTE: the .x termination which is standard
for this files is required.). This description uses the XDR language,
which resembles "C"-like structure-type declarations. More information 
and examples on how to write these ".x" files can be found in the 
man page for 'nddsgen'.

(2) 'nddsgen' was run on the p_gui.x file. This created the
p_gui_stubs.c, p_gui_xdr.c, p_gui.h 
and p_gui_test.c files.

(3) The p_gui_stubs.c was copied into p_gui.c; 
this file contains the functions, p_guiSeralize(), 
p_guiDeserialize(), and p_guiPrint() that are 
required to register the p_gui type with NDDS. 

(4) The user may want to fill in the code for the p_guiPrint()
function if he/she wants NDDS to print the p_gui automatically
in certain situations. This isn't required.

(5) The file p_gui.c also contains the function 
p_guiInit(). This function will register the 
p_gui type with NDDS.

(6) The p_gui_test.c contains code to test the 
serialization/deserialization functions. It is advisable to 
compile and run this program to verify proper operation.

SEE ALSO:
nddsgen, NddsXDR, NDDS, NddsTypeRegister.
--------------------------------------------------------------------------- */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "p_gui.h"

/* ========================================================================
   p_guiSerialize \- NDDS serialization method for p_gui

   Required NDDS method to serialize an p_gui into NDDSXDRStream 
   buffer.
   The data will be deserialized by the p_guiDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
boolean p_guiSerialize(NDDSXDRStream nddsds,
			      p_gui nddsp_gui,
			      int options)
{
    return xdr_gui(NddsXDRGetSerializingStream(nddsds),
			       nddsp_gui);
}

/* ========================================================================
   p_guiDeserialize \- NDDS deserialization method for p_gui 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the p_guiSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   p_gui of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error ocurred
 */
p_gui p_guiDeserialize(p_gui nddsp_gui,
				     NDDSXDRStream nddsds)
{
    int allocated = FALSE;

    if (nddsp_gui == NULL) {
	allocated = TRUE;
	nddsp_gui = calloc(1, sizeof(*nddsp_gui));
    }

    if (!xdr_gui(NddsXDRGetDeserializingStream(nddsds),
			     nddsp_gui))  {
	if (allocated) {
	    free(nddsp_gui);
	}
	return NULL;
    }
    
    return nddsp_gui;
}

/* ========================================================================
   p_guiPrint \- NDDS Print method for p_gui objects

   Optional NDDS method to print the contents of an p_gui.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
p_gui p_guiPrint(p_gui nddsp_gui)
{
    /* Do not remove. p_guiPrint must handle a NULL 
       p_gui 
       */
    if (nddsp_gui==NULL) {
	printf("p_gui: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsPrint_gui(nddsp_gui, "p_gui", 0)) {
	printf("NddsPrint_gui() failed on %p\n", nddsp_gui);
	return NULL;
    }

    /* Do not remove the return value */
    return nddsp_gui;
}

/* ========================================================================
   p_guiAllocate \- NDDS Allocate method for p_gui objects

   Optional NDDS method to allocate an NDDS object of type p_gui.

   If registered within p_guiNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a production that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that p_guiAllocate() is used.

   This method is not always required bacause p_guiDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by p_guiDeserialize() isn't sufficient. Registration
   of p_guiAllocate() allows to override the default allocation
   provided by p_guiDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function p_guiNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsConsumerAddSubscription() call.
 */
p_gui p_guiAllocate(const char *type, const char *name,
				  void *userParam)
{
    p_gui nddsp_gui;

    nddsp_gui = (p_gui)calloc(1, sizeof(*nddsp_gui));
    {
	/* Add the custom allocation of entries in the structure here */
    }

    return nddsp_gui;
}

/* ========================================================================
   p_guiFree \- NDDS Free method for p_gui objects

   Optional NDDS method to Free an NDDS object of type p_gui.

   This method is not used in the current version of NDDS.
 */
boolean p_guiFree(p_gui inst,
			 const char *type, const char *name,
			 void *userParam)
{
    return TRUE;
}

/* ========================================================================
   p_guiNddsRegister \- Install p_gui type to NDDS
   
   This function will register an p_gui type with NDDS.   
   Registration must happen before any reference to the p_gui 
   type is given to NDDS.
 */
void p_guiNddsRegister(void)
{
   NddsTypeRegister("p_gui",
		    (SerializeMethodType)p_guiSerialize,
		    (DeserializeMethodType)p_guiDeserialize,
		    (PrintMethodType)p_guiPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL);
}

