/*
   drivesys.h

   Mark Sibenac
   97-2-18
   Atacama Desert Trek
   Field Robotics Center

   This module is responsible for handling the four drive motors.

*/

#ifndef __DRIVESYS_H__
#define __DRIVESYS_H__

#include "common/nomad_global.h"
#include "semLib.h"
#include "drive.h"

#define PRIORITY_DSPID 80

class Cdrivesys {
 private:
  
  SEM_ID  m_semServo;   // semaphore to signal updating Servos

  int        m_drive_time_preset; // drive update sleep length
  int        m_drive_timer;       // countdown timer for drive update
  int        m_drive_freq;        // frequency of high level drive updates

  DRIVING_MODE_t m_Mode; // [AUTONOMOUS, MANUAL]

  void       ManualModeUpdate (); // Update Target Positions in Manual Mode

 public:
  Cdrivesys ();
 ~Cdrivesys ();
  
  int     Init          (); // must call this first, after amps are initialized

  int     UpdateServos  (); // updates the 4 Servo controllers
  int     SetUpdateFreq (int pid_freq, int traj_freq, int drive_freq);
  int     ChangeMode    (DRIVING_MODE_t mode); // [AUTONOMOUS, MANUAL]

  SEM_ID  GetSemServo   () {return m_semServo;}
  Cdrive *GetDrivePtr   (int drive_num); // drive_num := [0,6]
  DRIVING_MODE_t GetMode () {return m_Mode;} // [AUTONOMOUS, MANUAL]

  Cdrive *pFL; // front-left wheel
  Cdrive *pFR; // front-right wheel
  Cdrive *pBL; // back-left wheel
  Cdrive *pBR; // back-right wheel
  Cdrive *pLeft;  // left side steering
  Cdrive *pRight; // right side steering
};

extern Cdrivesys *drivesys; // defined in robot.cxx

#endif // __DRIVESYS_H__

