/*
  interface.cxx

  97-1-22
  Mark Sibenac
  Atacama Desert Trek
  Field Robotics Center

*/

#include "interface.h"
#include "interfaces/encoder/encoder.h"
#include "interfaces/dac/dac.h"
#include "interfaces/adc/adc.h"
#include "interfaces/di/di.h"
#include "interfaces/do/do.h"
#include "interfaces/relay/relay.h"

int InitInterfaces ()
{
  encoder = new Cencoder[8];
  dac     = new Cdac[8];
  adc     = new Cadc[32];
  di      = new Cdi[28];
  dout    = new Cdo[28];
  relay   = new Crelay[4];

  return 0;
}

int KillInterfaces ()
{
  delete encoder;
  delete dac;
  delete adc;
  delete di;
  delete dout;
  delete relay;

  return 0;
}
