/*
   encoder.h

   Mark Sibenac
   97-1-21
   Atacama Desert Trek
   Field Robotics Center

   This is the interface level encoder class. It assumes the device is a
   24 bit unsigned encoder board.

*/

#ifndef __ENCODER_H__
#define __ENCODER_H__

#include "common/nomad_global.h"
#include "devices/devices.h"

class Cencoder {
 private:

  int       nPort; // actual encoder chip number on device

  int       nLastEnc; // last 24-bit encoder reading
  long      lRolls; // number of rollovers in increments of 2^24

  Cdevices *pDevice;

 public:
  Cencoder();

  static int Register (int num_chan, Cdevices *device_ptr);

  long  GetEncoder     (); // returns a signed long int (64 bits) 
  int   PresetEncoder  (long value);
  int   SelectMode     (int mode);

  static char *Name () { return "Cencoder"; }
};

extern Cencoder *encoder; // array of encoders

#endif // __ENCODER_H__







