/*
   di.h

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This is the interface level di class. 
   
   Each digital channel is either at high=1 or low=0.

*/

#ifndef __DI_H__
#define __DI_H__

#include "common/nomad_global.h"
#include "devices/devices.h"


class Cdi {
 private:
  int nChan; // actual di channel on device

  Cdevices *pDevice;

  int nValue; // Value last read

 public:
  Cdi();

  static int Register (int num_chan, Cdevices *device_ptr);

  int GetDI ();
  int EnableIO ();              // turns on this block of input
  int DisableIO ();             // turns off this block of input

  static char *Name () { return "Cdi"; }
};

extern Cdi *di; // array of di's

#endif // __DI_H__







