/*
   dac.cxx

   Mark Sibenac
   97-1-21
   Atacama Desert Trek
   Field Robotics Center

   This is the interface level dac class.

*/

#include "dac.h"
#include "robot/robot.h"

Cdac *dac; // array of dacs

static int nTotalChannelsAlloced = 0;
static int nTotalChannelsRegistered = 0;


Cdac::Cdac()
{
  Dprintf(("Cdac::Cdac() creating new dac object\n"));

  fValue = double(0.0);
  nTotalChannelsAlloced++;
}

int Cdac::Register (int num_chan, Cdevices *device_ptr)
{
  ASSERT (num_chan >= 0);
    
  Dprintf(("Cdac::Register() called with num_chan=%d, nTotalChannelsAlloced=%d"
	   ", nTotalChannelsRegistered before call=%d\n", num_chan, 
	   nTotalChannelsAlloced, nTotalChannelsRegistered));

    for (int n=0; n < num_chan; n++)
      {  
	if (nTotalChannelsRegistered >= nTotalChannelsAlloced)
	  {
	    Dprintf(("Cdac::Register() too many channels registered.\n"));
	    return (-1);
	  }

	dac[nTotalChannelsRegistered].nChan = n;
	dac[nTotalChannelsRegistered].pDevice = device_ptr;

	++nTotalChannelsRegistered;
      }

  return 0;
}

double Cdac::GetDAC()
{
  return fValue;
}

int Cdac::SetDAC(double value)
{
  int status;

  fValue = value;
//  Dprintf(("pDevice=%x, nChan=%d, value=%f\n", pDevice, nChan, value)); 
  status = pDevice->SetDAC(nChan, value);
  return status;
}






