/*
 * imu.cxx
 *
 * Mark Sibenac
 * 97-3-4
 * Field Robotics Center
 * Atacama Desert Trek
 *
 */

#include "imu.h"
#include "ioLib.h"
#include "interfaces/adc/adc.h"
#include "imu_param.h"
#include "string.h"

/* update the registers */
void Cimu::updateState()
{
  if (semTake (m_SemMutex, NO_WAIT) == ERROR)
    {
      m_pAccels.new_data = 0;
      m_pRates.new_data  = 0;
      return;
    }

  ////////////////////////////////////////////////////////////////////
  ////////// ADD Voltage to Accel and Vel conversions here ///////////
  ////////////////////////////////////////////////////////////////////

  m_pAccels.X = (adc[ADC_X_ACCEL_CHAN].GetADC());
  m_pAccels.Y = (adc[ADC_Y_ACCEL_CHAN].GetADC());
  m_pAccels.Z = (adc[ADC_Z_ACCEL_CHAN].GetADC());

  m_pRates.X  = (adc[ADC_X_RATE_CHAN].GetADC());
  m_pRates.Y  = (adc[ADC_Y_RATE_CHAN].GetADC());
  m_pRates.Z  = (adc[ADC_Z_RATE_CHAN].GetADC());

  semGive (m_SemMutex);
}


Cimu::Cimu()
{
 // Initialize Accels and Rates to 0
  m_pAccels.X = 0.0;
  m_pAccels.Y = 0.0;
  m_pAccels.Z = 0.0;

  m_pRates.X  = 0.0;
  m_pRates.Y  = 0.0;
  m_pRates.Z  = 0.0;

  m_SemMutex = semMCreate(SEM_Q_FIFO | SEM_DELETE_SAFE);
  Dprintf(("Cimu::Cimu() m_SemMutex = %x\n", UINT32(m_SemMutex)));
}


Cimu::~Cimu()
{
}

// Simply copies the Accels structure into the passed in structure pointer
int Cimu::GetAccels (IMU_ACCEL_t *pAccels)
{
  semTake (m_SemMutex, WAIT_FOREVER);

  memcpy(pAccels, &m_pAccels, sizeof(IMU_ACCEL_t));

  semGive (m_SemMutex);

  return 0;
}

// Simply copies the Rates structure into the passed in structure pointer
int Cimu::GetRates (IMU_RATE_t *pRates)
{
  semTake (m_SemMutex, WAIT_FOREVER);

  memcpy(pRates, &m_pRates, sizeof(IMU_RATE_t));

  semGive (m_SemMutex);

  return 0;
}


