/*

   drive_param.h

   Mark Sibenac
   97-3-7
   Field Robotics Center
   Atacama Desert Trek

   This file defines constants and macros associated with the driving system.
*/

#ifndef __DRIVE_PARAM_H__
#define __DRIVE_PARAM_H__

// start of current feedback adc channels
#define CURRENT_FB_OFFSET (16)
// start of temperature fault di channels
#define TEMP_OFFSET       (8)

/* 
 Assuming wheel diameter is 76cm, 2700rpm, Max Speed of robot is 49.24cm/s
 Assuming 160:1 harmonic instead of 100:1, max speed is 30.78cm/s
 WHEEL_TICKS_REV = 1024(encoder tick/rev) * 100harmonic * 48pinion / 22spurr
 WHEEL_MAX_VEL = 2700(motor rpm) / 100(harmonic) / 48(pinion) * 22(spurr)
                 * 2PI(rads/rev) / 60(secs/min) = 1.2959 rads/s
 WHEEL_DEFAULT_ACCEL= (50cm/s)/(4s) = 12.5cm/s^2 = 685 rpm/s = 0.328776 rad/s^2
 WHEEL_MAX_MOTOR_TICKS_SEC = 2700rpm / 60s/min * 1024 tick/rev = 46080 tick/s
 WHEEL_DEFAULT_MOTOR_ACCEL = 685 rpm/s / 60 s/min * 1024 tick/rev 
                           = 11691 ticks/s^2
*/
const int    WHEEL_TICKS_REV            = 223418;         // ticks
const int    WHEEL_MAX_MOTOR_TICKS_SEC  = 46080;          // ticks/s
const int    WHEEL_DEFAULT_MOTOR_ACCEL  = 11691;          // ticks/s^2
const double WHEEL_MAX_VEL              = 1.29590696961;  // rad/s
const double WHEEL_DEFAULT_ACCEL        = 0.328776397843; // rad/s^2

/* Front Left Wheel Motor and Amp connection ports, and other constants */
#define WHEEL_FL_AMP         (amps[MOTOR_DRIVE_FL])
#define WHEEL_FL_ENCODER     (encoder[MOTOR_DRIVE_FL])
#define WHEEL_FL_CURRENT     (adc[CURRENT_FB_OFFSET + MOTOR_DRIVE_FL])
#define WHEEL_FL_COMMAND     (dac[MOTOR_DRIVE_FL])
#define WHEEL_FL_FAULT       (di[MOTOR_DRIVE_FL])
#define WHEEL_FL_TEMP        (di[TEMP_OFFSET + MOTOR_DRIVE_FL])
#define WHEEL_FL_ENABLE      (dout[MOTOR_DRIVE_FL])

/* Front Right Wheel Motor and Amp connection ports, and other constants */
#define WHEEL_FR_AMP         (amps[MOTOR_DRIVE_FR])
#define WHEEL_FR_ENCODER     (encoder[MOTOR_DRIVE_FR])
#define WHEEL_FR_CURRENT     (adc[CURRENT_FB_OFFSET + MOTOR_DRIVE_FR])
#define WHEEL_FR_COMMAND     (dac[MOTOR_DRIVE_FR])
#define WHEEL_FR_FAULT       (di[MOTOR_DRIVE_FR])
#define WHEEL_FR_TEMP        (di[TEMP_OFFSET + MOTOR_DRIVE_FR])
#define WHEEL_FR_ENABLE      (dout[MOTOR_DRIVE_FR])

/* Back Left Wheel Motor and Amp connection ports, and other constants */
#define WHEEL_BL_AMP         (amps[MOTOR_DRIVE_BL])
#define WHEEL_BL_ENCODER     (encoder[MOTOR_DRIVE_BL])
#define WHEEL_BL_CURRENT     (adc[CURRENT_FB_OFFSET + MOTOR_DRIVE_BL])
#define WHEEL_BL_COMMAND     (dac[MOTOR_DRIVE_BL])
#define WHEEL_BL_FAULT       (di[MOTOR_DRIVE_BL])
#define WHEEL_BL_TEMP        (di[TEMP_OFFSET + MOTOR_DRIVE_BL])
#define WHEEL_BL_ENABLE      (dout[MOTOR_DRIVE_BL])

/* Back Right Wheel Motor and Amp connection ports, and other constants */
#define WHEEL_BR_AMP         (amps[MOTOR_DRIVE_BR])
#define WHEEL_BR_ENCODER     (encoder[MOTOR_DRIVE_BR])
#define WHEEL_BR_CURRENT     (adc[CURRENT_FB_OFFSET + MOTOR_DRIVE_BR])
#define WHEEL_BR_COMMAND     (dac[MOTOR_DRIVE_BR])
#define WHEEL_BR_FAULT       (di[MOTOR_DRIVE_BR])
#define WHEEL_BR_TEMP        (di[TEMP_OFFSET + MOTOR_DRIVE_BR])
#define WHEEL_BR_ENABLE      (dout[MOTOR_DRIVE_BR])

/* 
 STEER_TICKS_REV = 1024(encoder tick/rev) * 160harmonic * 48pinion / 22spurr
 STEER_MAX_VEL = 2700(motor rpm) / 100(harmonic) / 48(pinion) * 22(spurr)
                 * 2PI(rads/rev) / 60(secs/min) = 1.2959 rads/s
 STEER_DEFAULT_ACCEL= (50cm/s)/(4s) = 12.5cm/s^2 = 685 rpm/s = 0.328776 rad/s^2
 STEER_MAX_MOTOR_TICKS_SEC = 2700rpm / 60s/min * 1024 tick/rev = 46080 tick/s
 STEER_DEFAULT_MOTOR_ACCEL = 685 rpm/s / 60 s/min * 1024 tick/rev 
                           = 11691 ticks/s^2
*/
const int    STEER_TICKS_REV            = 223418;         // ticks
const int    STEER_MAX_MOTOR_TICKS_SEC  = 46080;          // ticks/s
const int    STEER_DEFAULT_MOTOR_ACCEL  = 11691;          // ticks/s^2
const double STEER_MAX_VEL              = 1.29590696961;  // rad/s
const double STEER_DEFAULT_ACCEL        = 0.328776397843; // rad/s^2

/* Left Steering Servo and Amp connection ports, and other constants */
#define STEER_LEFT_AMP         (amps[MOTOR_STEER_L])
#define STEER_LEFT_ENCODER     (encoder[MOTOR_STEER_L])
#define STEER_LEFT_CURRENT     (adc[CURRENT_FB_OFFSET + MOTOR_STEER_L])
#define STEER_LEFT_COMMAND     (dac[MOTOR_STEER_L])
#define STEER_LEFT_FAULT       (di[MOTOR_STEER_L])
#define STEER_LEFT_TEMP        (di[TEMP_OFFSET + MOTOR_STEER_L])
#define STEER_LEFT_ENABLE      (dout[MOTOR_STEER_L])

/* Right Steering Servo and Amp connection ports, and other constants */
#define STEER_RIGHT_AMP         (amps[MOTOR_STEER_R])
#define STEER_RIGHT_ENCODER     (encoder[MOTOR_STEER_R])
#define STEER_RIGHT_CURRENT     (adc[CURRENT_FB_OFFSET + MOTOR_STEER_R])
#define STEER_RIGHT_COMMAND     (dac[MOTOR_STEER_R])
#define STEER_RIGHT_FAULT       (di[MOTOR_STEER_R])
#define STEER_RIGHT_TEMP        (di[TEMP_OFFSET + MOTOR_STEER_R])
#define STEER_RIGHT_ENABLE      (dout[MOTOR_STEER_R])

#endif /* __DRIVE_PARAM_H__ */
