/*
   devices.h

   Mark Sibenac
   97-1-15
   Atacama Desert Trek
   Field Robotics Center

   This is the definition of the devices class. It is a general description
   of what member functions a device would have.
*/

#ifndef __DEVICES_H__
#define __DEVICES_H__

#include "common/nomad_global.h"

#define  SINGLE_ENDED  0
#define  DIFFERENTIAL  1

#define  ERROR_ADC_I  -10000

class Cdevices {
 private:

 protected:
  char *pBoardBaseAddress;

 public:

// These functions are general and may or may not be implemented in the devices
  virtual int    Init          ()            {return -1;}

  virtual int    Read          (int)         {return -1;}
  virtual int    Write         (int, int)    {return -1;}

// These functions are for accessing encoders
  virtual int    GetEncoder    (int)         {return -1;}
  virtual int    PresetEncoder (int, int)    {return -1;}
  virtual int    SelectMode    (int, int)    {return -1;}
  virtual int    CounterReset  ()            {return -1;}

// These functions are for accessing adc
  virtual double GetADC        (int)         {return -1;}

// These functions are for accessing dac 
  virtual int    SetDAC        (int, double) {return -1;}

// These functions are for accessing relays
  virtual int    SetRelay      (int, int)    {return -1;}

// These functions are for accessing di
  virtual int    GetDI         (int)         {return -1;}
  virtual int    EnableIO      ()            {return -1;}
  virtual int    DisableIO     ()            {return -1;}

// These functions are for accessing do
  virtual int    SetDO         (int, int)    {return -1;}
//virtual int    EnableIO      ()            {return -1;}
//virtual int    DisableIO     ()            {return -1;}
};

#endif // __DEVICES_H__
