/*
  pass.c

  Mark Sibenac
  96-1-14
  Field Robotics Center

  Makes serial communications pass transparently thru the two serial ports on
  a vxworks computer board.

  call pass to automatically spawn the low level transparency code.

  */

#include "pass.h"
#include "serial.h"

int pass (void)
{
  int fd0, fd1;
  char buff[2];

  buff[0] = buff[1] = 0;

  if ((fd0 = serialInit ("/tyCo/0", 9600)) == -1)
    return -1;
  if ((fd1 = serialInit ("/tyCo/1", 9600)) == -1)
    return -2;

  serialFlushBuffer (fd0);
  serialFlushBuffer (fd1);

  while (1)
    {
      if (serialNumChars (fd0))
	{
	  serialGetBuf(fd0, buff, 1, -1);
	  serialPutBuf(fd1, buff, 1);
	}

      if (serialNumChars (fd1))
	{
	  serialGetBuf(fd1, buff, 1, -1);
	  serialPutBuf(fd0, buff, 1);
	}
    }
}
