/*
   test_drive.h

   Mark Sibenac
   97-1-29
   Atacama Desert Trek
   Field Robotics Center

   This tests the drive interface.

*/

#ifndef __TEST_DRIVE_H__
#define __TEST_DRIVE_H__

#include "modules/drive/drive.h"
#include "modules/drive/drivesys.h"

extern "C" {
  int drive_Init        (int drive_freq, int pid_freq, int traj_freq);
  int drive_SetFreq     (int drive_freq, int pid_freq, int traj_freq);
  int drive_servoISR   (int);
  void drive_startISR   (int freq);
  void drive_stopISR    ();
  int drive_ChangeState (int drive_num, motor_state_t value);
  int drive_ChangeMode  (DRIVING_MODE_t mode);
  DRIVING_MODE_t drive_GetMode ();
  int drive_GetState    (int drive_num);
  int drive_GetPID      (int drive_num);
  int drive_GetAmp      (int drive_num);
  int drive_SetPID      (int drive_num);
  int drive_SetDes      (int drive_num, double des);
  int drive_SetAmp      (int drive_num);
  int drive_Disable     (int drive_num);
  int drive_Enable      (int drive_num);
  int drive_Scope       (int drive_num, int freq); // captures to stethoscope at freq
  int drive_SetTarget   (int drive_num);
  int drive_SetTargetAngle   (int drive_num);
  int drive_SetTargetVel   (int drive_num);
  int drive_SetTraject  (int drive_num);
  int drive_SetVelTraject  (int drive_num);
  int drive_GetTraject  (int drive_num);
  int drive_Reset       (int drive_num);
}

#endif // __TEST_DRIVE_H__
