/*
   test_di.cxx

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This tests the di interface.

*/

#include "test_di.h"
#include "scopeprobe.h"
#include "taskLib.h"
#include "sysLib.h"

#define NUM_DI 28

// Enables the di for each block
int di_Init (void)
{
  for (int i=0; i<NUM_DI; i++)
    { di[i].EnableIO(); }
  return 0;
}

// print di0-di7
int di_Read_0 (void)
{
  for (int i=0; i<=7; i++)
    printf("di%d = %d\n", i, di[i].GetDI());
  return 0;
}

// print di8-di19
int di_Read_8 (void)
{
  for (int i=8; i<=19; i++)
    printf("di%d = %d\n", i, di[i].GetDI());
  return 0;
}

// print di20-di27
int di_Read_20 (void)
{
  for (int i=20; i<=27; i++)
    printf("di%d = %d\n", i, di[i].GetDI());
  return 0;
}

// gets the value from di
int di_Read  (int di_num)
{
  return di[di_num].GetDI();
}            

// captures to stethoscope at freq
int di_Scope (int freq)
{
  int  nVal[NUM_DI];
  char name[20];
  int  n;

  if ((freq < 0) || (freq > sysClkRateGet()))
    {
      printf("freq = %d must be between 0 and %d\n", freq, sysClkRateGet());
      return -1;
    }

  for (n=0; n<NUM_DI; n++)
    {
      sprintf(name, "di:chan%d", n);
      ScopeInstallSignal(name, "boolean", &nVal[n], "int", 0);
    }

  ScopeChangeSampleRate(double(freq), 0);

  while(1)
    {
      for(n=0; n<NUM_DI; n++)
	{
	  nVal[n] = di[n].GetDI();
	}
      ScopeCollectSignals(0);
      taskDelay(sysClkRateGet()/freq);
    }

  return 0;
}

