/*
   test_dac.cxx

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This tests the dac interface.

*/

#include "test_dac.h"
#include "scopeprobe.h"
#include "taskLib.h"
#include "sysLib.h"

// gets the value from dac
double dac_Read  (int dac_num)
{
  return dac[dac_num].GetDAC();
}            

// preset the value of dac
int dac_Write (int dac_num, double value)
{
  return dac[dac_num].SetDAC(value);
}

// captures to stethoscope at freq
int dac_Scope (int freq)
{
  double  fVal[8];
  char name[20];
  int  n;

  if ((freq < 0) || (freq > sysClkRateGet()))
    {
      printf("freq = %d must be between 0 and %d\n", freq, sysClkRateGet());
      return -1;
    }

  for (n=0; n<8; n++)
    {
      sprintf(name, "dac:chan%d", n);
      ScopeInstallSignal(name, "volts", &fVal[n], "double", 0);
    }

  ScopeChangeSampleRate(double(freq), 0);

  while(1)
    {
      for(n=0; n<8; n++)
	{
	  fVal[n] = dac[n].GetDAC();
	}
      ScopeCollectSignals(0);
      taskDelay(sysClkRateGet()/freq);
    }

  return 0;
}

