/*
 * rt_interface.h
 *
 * Mark Sibenac
 * 97-2-24
 * Field Robotics Center
 * Atacama Desert Trek
 *
 * This file defines the interface functions to get information from the
 * real-time box. It accesses the proper data structures with the proper
 * mutual exclusion. Send it a pointer to your allocated structure, and the
 * function will fill your memory. It will return a 0 on success. Failures
 * may be caused by sending it a null pointer, or failure to obtain a
 * semaphore.
 * 
 */

#ifndef __RT_INTERFACE_H__
#define __RT_INTERFACE_H__

#include "rt_data.h"

/* The following functions return 0 on success, and a failure code otherwise */

int    GetSMComputingStatus (computing_status_ptr);
int    GetSMLocomotionData  (locomotion_data_ptr);
int    GetSMApsData         (aps_data_ptr);
int    GetSMPowerStatus     (power_status_ptr);
int    GetSMWeatherData     (weather_data_ptr);
int    GetSMNavCommand      (nav_command_ptr);
int    GetSMLaserSight      (laser_sight_ptr);
int    GetSMPendantCommand  (pendant_command_ptr);
int    GetSMGpsDerived      (gps_derived_ptr);
int    GetSMGpsRaw          (gps_raw_ptr);
int    GetSMImuRaw          (imu_raw_ptr);

#endif /* __RT_INTERFACE_H__ */
