
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>


double _antPos[3];       //Antenna position (now [0,0,0])
double _roverPos[3];     //Rover position   (now [1000,0,0])
double _stationPos[3];   //Station position (now [0,0,0])
double _roverAng[3];     //Rover attitude (now [yaw,pitch,roll])
double _antAng[3];       //Output         (now [yaw,pitch])




int aimAntennaClassexecute()
{

  // Declare temporal variables for all the sines and cosines
  double deltaXsv,deltaYsv,deltaZsv; /* delta pos vehicle and station in {G} */
  double xA,yA,zA; /* position of the antenna in {V} */
  double cYaw,sYaw; /* cosines and sine of yaw */
  double cPitch,sPitch;
  double cRoll,sRoll;
  double antYaw,antPitch;
  double xSb,ySb,zSb; /* Coordinates of station in {B} */

  // Asigns values to the antenna position on the rover
  xA = _antPos[0];
  yA = _antPos[1];
  zA = _antPos[2];

  // Asigns actual values to the delta variables
  deltaXsv = _roverPos[0] - _stationPos[0];
  deltaYsv = _roverPos[1] - _stationPos[1];
  deltaZsv = _roverPos[2] - _stationPos[2];

  // Asigns actual values to sines and cosines
  cYaw   = cos( _roverAng[0] );
  cPitch = cos( _roverAng[1] );
  cRoll  = cos( _roverAng[2] );

  sYaw   = sin( _roverAng[0] );
  sPitch = sin( _roverAng[1] );
  sRoll  = sin( _roverAng[2] );

  // Gets station coordinates in {B} frame
  xSb = deltaXsv*(cYaw*cPitch)+
        deltaYsv*(sYaw*cPitch)-
	deltaZsv*sPitch-xA;

  ySb = deltaXsv*(cYaw*sPitch*sRoll-sYaw*cRoll)+
        deltaYsv*(sYaw*sPitch*sRoll+cYaw*cRoll)+
	deltaZsv*(cPitch*sRoll)-yA;

  zSb = deltaXsv*(cYaw*sPitch*cRoll+sYaw*sRoll)+
        deltaYsv*(sYaw*sPitch*cRoll-cYaw*sRoll)+
	deltaZsv*(cPitch*cRoll)-zA;

  // Calculates antenna yaw and pitch
  antYaw   = atan2(xSb,ySb);
  antPitch = atan2(zSb,sqrt(xSb*xSb+ySb*ySb));

  // Asigns the value to the actual output matrix
  _antAng[0] = antYaw;
  _antAng[1] = antPitch;
  

    // If Error, return non-zero
    return (0);
}

