/* p_kvhDerivedStateStruct_producer.c \- A producer of data of type p_kvhDerivedStateStruct

   This file is derived from code automatically generated by nddsgen.

   modification history
   ------------ -------
   19a,29aug95,gpc Mofified for version 1.9
   RTI,30may94,sas cleanup.
   RTI,02apr94,gpc Auto-generated code template written.
 */

static char copyright_rti[] = 
"(c) Copyright, Real-Time Innovations, Inc., 1994.  All rights reserved.";

/*
DESCRIPTION:
Example producer of type p_kvhDerivedStateStruct automatically generated by 'nddsgen'
To test them follow these steps:

(1) Compile this file and the example consumer.

(2) Start NDDS with nddsStartDaemon -d <domain> on the machines where
the test will be run. For more details see the man page on nddsStartDaemon.

(3) Make sure your environment variable NDDS_PEER_HOSTS is set to at least
contain the machines where the test will be run.

(4) Start the producer on the same domain used for NDDS with the command
sun4/p_kvhDerivedStateStruct_producer  <domain>

(5) Start the consumer on the same domain used for NDDS with the command
sun4/p_kvhDerivedStateStruct_producer  <domain>

--------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include "NDDS.h"
#include "p_kvhDerivedStateStruct.h"


void producerMain(int argc, char *argv[])
{
    int count, nddsDomain = 0;
    unsigned int send_period_us = 4000000; /* 4 seconds */
    NDDSProducer itemProducer;
    p_kvhDerivedStateStruct item1;
    float persistence = 15.0f;
    float strength = 1.0f;

    if (argc >=2) {
	nddsDomain = atoi(argv[1]);
    }

    NddsInit(nddsDomain);
    NddsVerbositySet(1);

    p_kvhDerivedStateStructNddsRegister();

    item1 = (p_kvhDerivedStateStruct)calloc(1, sizeof(*item1));
    printf("User Initialization of a p_kvhDerivedStateStruct\n");
    {
	/* Your initialization code goes here! */
    }
       
    itemProducer = NddsProducerCreate("Producer", NDDS_ASYNCHRONOUS,
				      persistence, strength);

    NddsProducerProductionAdd(itemProducer, "p_kvhDerivedStateStruct",
			      "Example p_kvhDerivedStateStruct", item1,
			      0, NULL, NULL);

    for (count=0;;count++) {
	printf("Sampling producer, count %d\n", count);
	NddsProducerSample(itemProducer);
	NddsUtilitySleep(send_period_us);

	/* modify the data produced here */
    }
}


#ifndef RTS_VXWORKS
void main(int argc, char *argv[])
{
    producerMain(argc, argv);
}
#endif

