/*
   relay.cxx

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This is the interface level relay class.

*/

#include "relay.h"
#include "robot/robot.h"

Crelay *relay; // array of relay's

static int nTotalChannelsAlloced = 0;
static int nTotalChannelsRegistered = 0;


Crelay::Crelay()
{
  Dprintf(("Crelay::Crelay() creating new relay object\n"));

  nState = 0; // Relay is open, initially
  nTotalChannelsAlloced++;
}

int Crelay::Register (int num_chan, Cdevices *device_ptr)
{
  ASSERT (num_chan >= 0);
    
  Dprintf(("Crelay::Register() called with num_chan=%d, "
	   "nTotalChannelsAlloced=%d, nTotalChannelsRegistered before "
	   "call=%d\n", num_chan, nTotalChannelsAlloced, 
	   nTotalChannelsRegistered));

    for (int n=0; n < num_chan; n++)
      {  
	if (nTotalChannelsRegistered >= nTotalChannelsAlloced)
	  {
	    Dprintf(("Crelay::Register() too many channels registered.\n"));
	    return (-1);
	  }

	relay[nTotalChannelsRegistered].nChan   = n;
	relay[nTotalChannelsRegistered].pDevice = device_ptr;

	++nTotalChannelsRegistered;
      }

  return 0;
}

int Crelay::SetRelay(int state)
{
  nState = state;
  return (pDevice->SetRelay(nChan, state));
}



