/*
   do.cxx

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This is the interface level do class.

*/

#include "do.h"
#include "robot/robot.h"

Cdo *dout; // array of do's

static int nTotalChannelsAlloced = 0;
static int nTotalChannelsRegistered = 0;


Cdo::Cdo()
{
  Dprintf(("Cdo::Cdo() creating new do object\n"));

  nValue = 0; // default to low
  nTotalChannelsAlloced++;
}

int Cdo::Register (int num_chan, Cdevices *device_ptr)
{
  ASSERT (num_chan >= 0);
    
  Dprintf(("Cdo::Register() called with num_chan=%d, nTotalChannelsAlloced=%d"
	   ", nTotalChannelsRegistered before call=%d\n", num_chan, 
	   nTotalChannelsAlloced, nTotalChannelsRegistered));

    for (int n=0; n < num_chan; n++)
      {  
	if (nTotalChannelsRegistered >= nTotalChannelsAlloced)
	  {
	    Dprintf(("Cdo::Register() too many channels registered.\n"));
	    return (-1);
	  }

	dout[nTotalChannelsRegistered].nChan   = n;
	dout[nTotalChannelsRegistered].pDevice = device_ptr;

	++nTotalChannelsRegistered;
      }

  return 0;
}

int Cdo::SetDO(int value)
{
  nValue = pDevice->SetDO(nChan, value);

  return (nValue);
}

// turns on this block of output
int Cdo::EnableIO ()
{
  return pDevice->EnableIO();
}

// turns off this block of output
int Cdo::DisableIO ()
{
  return pDevice->DisableIO();
}




