/*
   di.cxx

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This is the interface level di class.

*/

#include "di.h"
#include "robot/robot.h"

Cdi *di; // array of di's

static int nTotalChannelsAlloced = 0;
static int nTotalChannelsRegistered = 0;


Cdi::Cdi()
{
  Dprintf(("Cdi::Cdi() creating new di object\n"));

  nValue = 0; // This is really a guess
  nTotalChannelsAlloced++;
}

int Cdi::Register (int num_chan, Cdevices *device_ptr)
{
  ASSERT (num_chan >= 0);
    
  Dprintf(("Cdi::Register() called with num_chan=%d, nTotalChannelsAlloced=%d"
	   ", nTotalChannelsRegistered before call=%d\n", num_chan, 
	   nTotalChannelsAlloced, nTotalChannelsRegistered));

    for (int n=0; n < num_chan; n++)
      {  
	if (nTotalChannelsRegistered >= nTotalChannelsAlloced)
	  {
	    Dprintf(("Cdi::Register() too many channels registered.\n"));
	    return (-1);
	  }

	di[nTotalChannelsRegistered].nChan   = n;
	di[nTotalChannelsRegistered].pDevice = device_ptr;

	++nTotalChannelsRegistered;
      }

  return 0;
}

int Cdi::GetDI()
{
  nValue = pDevice->GetDI(nChan);

  return (nValue);
}


// turns on this block of input
int Cdi::EnableIO ()
{
  return pDevice->EnableIO();
}

// turns off this block of input
int Cdi::DisableIO ()
{
  return pDevice->DisableIO();
}




