/*
 * 
 * imu.h
 *
 * Mark Sibenac
 * Atacama Desert Trek
 * 96-12-18
 *
 * This is the header file that describes the imu class. It is for the
 * BEI IMU.
 *
 */

#ifndef __IMU_H__
#define __IMU_H__

#include "common/nomad_global.h"
#include "semLib.h"

typedef struct {
  double X;        // units of g
  double Y;        // units of g
  double Z;        // units of g
  char   new_data; // flag that signifies new data (1-new, 0-old)
} IMU_ACCEL_t;

typedef struct {
  double X;        // units of rad/s
  double Y;        // units of rad/s
  double Z;        // units of rad/s
  char   new_data; // flag that signifies new data (1-new, 0-old)
} IMU_RATE_t;

class Cimu {
 private:

  IMU_ACCEL_t  m_pAccels;  // the three linear acceleration channels
  IMU_RATE_t   m_pRates;   // the three angular rate channels

  SEM_ID       m_SemMutex; // Mutual Exclusion Semaphore

 public:
  Cimu (); // constructor
 ~Cimu(); // destructor

  void updateState (); // task that updates registers
  
  int GetAccels(IMU_ACCEL_t *pAccels); // fills in the pAccels structure
  int GetRates(IMU_RATE_t *pRates);    // fills in the pRates structure
};

extern Cimu *imu; // declaration of the imu object

#endif // __IMU_H__
