/*
 * robot.h
 *
 * Mark Sibenac
 * 96-1-8
 * Field Robotics Center
 * Atacama Desert Trek
 *
 * This is the Robot Class Header file.
 *
 * The Robot Class is the mother class which holds all of the objects.
 *
 */

#ifndef __ROBOT_H__
#define __ROBOT_H__

#include "common/nomad_global.h"
#include "interfaces/interface.h"
#include "devices/device_hardware.h"
#include "modules/modules.h"
#include "components/components.h"
#include "semLib.h"

class Crobot {
 private:
  
  SEM_ID      m_SemUpdate; // semaphore that signals the update cycle

 protected:


 public:

  Crobot(); // Constructor
 ~Crobot(); // Destructor

  int         Cycle1            (); // Periodic function running at high freq
  int         Cycle2            (); // Periodic function running at high freq
  int         Cycle3            (); // Periodic function running at high freq

  SEM_ID      GetUpdateSem      () {return m_SemUpdate;}

  // Modules that robot is in charge of

  Cdrivesys *drivesys; // The pointer to the driving system
  Cpointsys *pointsys; // The pointer to the pointing system

};

extern Crobot *robot; // The robot pointer

extern "C" {
  int InitRobot();
  int KillRobot();
  void __do_global_ctors();
  void __do_global_dtors();
}
#endif // __ROBOT_H__
