/*
  nomad_global.h

  96-12-19
  Mark Sibenac
  Field Robotics Center
*/

#ifndef __NOMAD_GLOBAL_H__
#define __NOMAD_GLOBAL_H__

#define DEBUG1

#include <vxWorks.h>
#include <sysLib.h>
#include <vme.h>
#include <stdioLib.h>

#include "common/nomad_types.h"

#define DEBUG1

#define Dprintf(x) printf x;

#define ASSERT(x)  if (!(x)) { \
			 printf("%s missed assertion\n", Name()); \
			 return; \
			 } \

const int BIT_24   = 16777216; 
const int BIT_23   = 8388608;

const double       PI       = 3.141592653589793238462643383279502884197169399375105820974944592307816406286;
const double       PI_2     = 6.283185307179586476925286766559005768394338798750211641949889184615632812572;
const double       NEG_PI   = -3.141592653589793238462643383279502884197169399375105820974944592307816406286;
const double       NEG_PI_2 = -6.283185307179586476925286766559005768394338798750211641949889184615632812572;

#define DECTORAD(x) ((x)/180.0*PI)
#define RADTODEC(x) ((x)/PI*180.0)

#define CLOCK_WISE         (1)
#define COUNTER_CLOCK_WISE (0)

#endif // __NOMAD_GLOBAL_H
