#define CPU MC68030

#include <stdioLib.h>
#include <ioLib.h>
#include <tyLib.h>
#include "serial.h"

/*******************
serial stuff
******************/

/* Initialize serial communications to a particular port. Returns the */
/* file descriptor, or -1 for failure. */
extern int serialInit(char *portName, int speed)
{
    int fd;

    /* Open the port */
    if ((fd = open(portName, O_RDWR, 0)) < 0) {
	printf("Could not open serial port %s!\n", portName);
	return(-1);
    }

    ioctl(fd, FIOSETOPTIONS, OPT_RAW);
    ioctl(fd, FIOFLUSH, 0);
    ioctl(fd, FIOBAUDRATE, 9600);

    return(fd);
}


/* Return the number of characters waiting to be read from the port */
extern int serialNumChars(int fd)
{
    int count;

    ioctl(fd, FIONREAD, (int)&count);
    return(count);
}


/* Flush the port's input buffer */
extern void serialFlushBuffer(int fd)
{
    ioctl(fd, FIORFLUSH, 0);
}


/* Send a null-terminated string to the port */
extern void serialPutBuf(int fd, char *buf, int count)
{
    write(fd, buf, count);
}


extern int serialRead(int fd, char *buf)
{
    int i = 0;
    char c;

/*    read(fd, &c, 1);
    printf("first:%c\n",c);
    if (buf[0] != 'U') {
	serialFlushBuffer(fd);
	return(0);
    }
*/
    while (1) {
	printf("%s\n",buf);
	read(fd,&(buf[i]),1);
	printf("->buf[%d]:%c\n",i,buf[i]);
	if (buf[i] == 'x') 
	    break;
	i++;
    }
    serialFlushBuffer(fd);
    
}

/* Read the specified number of characters from the port.		*/
/* Returns the number of characters read.				*/
/* If timeout > 0, return after many milliseconds (or as soon as the	*/
/*		   num_chars characters have been read).		*/
/* If timeout = 0, return right away with as many characters as are	*/
/*		   available, but no more than num_chars.		*/
/* If timeout < 0, block until num_chars characters have been read.	*/
extern int serialGetBuf(int fd, char *buffer, int num_chars, int timeout)
{
    int count;

    if (timeout < 0) {
	count = read(fd, buffer, num_chars);
	return(count);
    }

    if (timeout == 0) {
	ioctl(fd, FIONREAD, (int)&count);
	if (count > num_chars) count = num_chars;
	count = read(fd, buffer, count);
	return(count);
    }

    return(0);
}









