/*
   test_relay.cxx

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This tests the relay interface.

*/

#include "test_relay.h"
#include "scopeprobe.h"
#include "taskLib.h"
#include "sysLib.h"

// gets the value from relay
int relay_Read  (int relay_num)
{
  return relay[relay_num].GetRelay();
}            

// sets the state of the relay
// 0-open, 1-closed
int relay_Set (int relay_num, int state)
{
  return relay[relay_num].SetRelay(state);
}            

// captures to stethoscope at freq
int relay_Scope (int freq)
{
  int  nVal[4];
  char name[20];
  int  n;

  if ((freq < 0) || (freq > sysClkRateGet()))
    {
      printf("freq = %d must be between 0 and %d\n", freq, sysClkRateGet());
      return -1;
    }

  for (n=0; n<4; n++)
    {
      sprintf(name, "relay:chan%d", n);
      ScopeInstallSignal(name, "boolean", &nVal[n], "int", 0);
    }

  ScopeChangeSampleRate(double(freq), 0);

  while(1)
    {
      for(n=0; n<4; n++)
	{
	  nVal[n] = relay[n].GetRelay();
	}
      ScopeCollectSignals(0);
      taskDelay(sysClkRateGet()/freq);
    }

  return 0;
}

