/*
   test_enc.cxx

   Mark Sibenac
   97-1-17
   Atacama Desert Trek
   Field Robotics Center

   This tests the encoder interface.

*/

#include "test_enc.h"
#include "scopeprobe.h"
#include "taskLib.h"
#include "sysLib.h"

// gets the value from enc
int enc_Read  (int enc_num)
{
  return encoder[enc_num].GetEncoder();
}            

// preset the value of enc
int enc_Write (int enc_num, int value)
{
  return encoder[enc_num].PresetEncoder(value);
}

// captures to stethoscope at freq
int enc_Scope (int freq)
{
  int  nVal[4];
  char name[20];
  int  n;

  if ((freq < 0) || (freq > sysClkRateGet()))
    {
      printf("freq = %d must be between 0 and %d\n", freq, sysClkRateGet());
      return -1;
    }

  for (n=0; n<4; n++)
    {
      sprintf(name, "encoder:chan%d", n);
      ScopeInstallSignal(name, "ticks", &nVal[n], "int", 0);
    }

  ScopeChangeSampleRate(double(freq), 0);

  while(1)
    {
      for(n=0; n<4; n++)
	{
	  nVal[n] = encoder[n].GetEncoder();
	}
      ScopeCollectSignals(0);
      taskDelay(sysClkRateGet()/freq);
    }

  return 0;
}

