/*
   test_di.cxx

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This tests the di interface.

*/

#include "test_di.h"
#include "scopeprobe.h"
#include "taskLib.h"
#include "sysLib.h"

// gets the value from di
int di_Read  (int di_num)
{
  return di[di_num].GetDI();
}            

// captures to stethoscope at freq
int di_Scope (int freq)
{
  int  nVal[27];
  char name[20];
  int  n;

  if ((freq < 0) || (freq > sysClkRateGet()))
    {
      printf("freq = %d must be between 0 and %d\n", freq, sysClkRateGet());
      return -1;
    }

  for (n=0; n<27; n++)
    {
      sprintf(name, "di:chan%d", n);
      ScopeInstallSignal(name, "boolean", &nVal[n], "int", 0);
    }

  ScopeChangeSampleRate(double(freq), 0);

  while(1)
    {
      for(n=0; n<27; n++)
	{
	  nVal[n] = di[n].GetDI();
	}
      ScopeCollectSignals(0);
      taskDelay(sysClkRateGet()/freq);
    }

  return 0;
}

