/*
   test_adc.cxx

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This tests the adc interface.

*/

#include "test_adc.h"
#include "scopeprobe.h"
#include "taskLib.h"
#include "sysLib.h"

#define NUM_ADC 32

// gets the value from adc
double adc_Read  (int adc_num)
{
  return adc[adc_num].GetADC();
}            

// captures to stethoscope at freq
int adc_Scope (int freq)
{
  double fVal[NUM_ADC];
  char name[20];
  int n;

  if ((freq < 0) || (freq > sysClkRateGet()))
    {
      printf("freq = %d must be between 0 and %d\n", freq, sysClkRateGet());
      return -1;
    }

  for (n=0; n<NUM_ADC; n++)
    {
      sprintf(name, "adc:chan%d", n);
      ScopeInstallSignal(name, "volt", &fVal[n], "double", 0);
    }

  ScopeChangeSampleRate(double(freq), 0);

  while(1)
    {
      for(n=0; n<NUM_ADC; n++)
	{
	  fVal[n] = adc[n].GetADC();
	}
      ScopeCollectSignals(0);
      taskDelay(sysClkRateGet()/freq);
    }

  return 0;
}

