/*
   robot.cxx

   Mark Sibenac
   97-1-22
   Atacama Desert Trek
   Field Robotics Center


   This is the top level class that instantiates everything else.

   Call InitRobot() to install all devices and interfaces and whatever other
   modules need to be installed.

*/

#include "robot.h"

extern "C" {int on_exit(int);}

int on_exit(int)
{
 printf("on_exit() Done...\n");
 return 0;
}

extern int mutexes_installed; // defined in devices/vmio/vmio10.cxx

// Kinda like main(). Should be called first.
int InitRobot()
{
  __do_global_ctors();

  InitInterfaces();
  mutexes_installed = 0; // make it false
  InitHardware();
  RegisterHardware();
  InitComponents();
  InitModules();

  return 0;
}

int KillRobot()
{
  printf("Killing Robot\n");

  KillModules();
  KillComponents();
  KillHardware();
  KillInterfaces();

  __do_global_dtors();

  return 0;
}
