/*

   point_param.h

   Mark Sibenac
   97-3-1
   Field Robotics Center
   Atacama Desert Trek

   This file defines constants and macros associated with the pointing system.
*/

#ifndef __POINT_PARAM_H__
#define __POINT_PARAM_H__

/* Azimuth Motor and Amp connection ports, and other constants */
#define AZ_AMP         (amps[MOTOR_POINT_AZIMUTH])
#define AZ_ENCODER     (encoder[MOTOR_POINT_AZIMUTH])
#define AZ_CURRENT     (adc[22])
#define AZ_COMMAND     (dac[MOTOR_POINT_AZIMUTH])
#define AZ_FAULT       (di[MOTOR_POINT_AZIMUTH])
#define AZ_TEMP        (0)
#define AZ_ENABLE      (dout[MOTOR_POINT_AZIMUTH])
/* AZ_MAX_VEL = 3000(motor rpm) / 150(harmonic) * 2PI(rads/rev) / 60(secs/min)
   AZ_DEFAULT_ACCEL= PI rad/s^2
   AZ_MAX_MOTOR_TICKS_SEC = 3000rpm / 60s/min * 1000 tick/rev = 50000 tick/s
   AZ_DEFAULT_ACCEL = PI / 2 / PI * 150 * 1000 tick/rev = 75000 ticks/s^2
*/
const int    AZ_TICKS_REV            = 1000 * 150;     // ticks
const int    AZ_MAX_MOTOR_TICKS_SEC  = 50000;          // ticks/s
const int    AZ_DEFAULT_MOTOR_ACCEL  = 75000;          // ticks/s^2
const double AZ_MAX_VEL              = 1.29590696961;  // rad/s
const double AZ_DEFAULT_ACCEL        = 0.328776397843; // rad/s^2


/* Elevation Motor and Amp connection ports, and other constants */
#define EL_AMP         (amps[MOTOR_POINT_ELEVATION])
#define EL_ENCODER     (encoder[MOTOR_POINT_ELEVATION])
#define EL_CURRENT     (adc[23])
#define EL_COMMAND     (dac[MOTOR_POINT_ELEVATION])
#define EL_FAULT       (di[MOTOR_POINT_ELEVATION])
#define EL_TEMP        (0)
#define EL_ENABLE      (dout[MOTOR_POINT_ELEVATION])
/* EL_MAX_VEL = 3000(motor rpm) / 88(harmonic) * 2PI(rads/rev) / 60(secs/min)
   Assuming wheel diameter is 76cm, 2700rpm, Max Speed of robot is 49.24cm/s
   EL_DEFAULT_ACCEL= (50cm/s)/(4s) = 12.5cm/s^2 = 685 rpm/s = 0.328776 rad/s^2
   EL_MAX_MOTOR_TICKS_SEC = 2700rpm / 60s/min * 1024 tick/rev = 46080 tick/s
   EL_DEFAULT_ACCEL = 685 rpm/s / 60 s/min * 1024 tick/rev = 11691 ticks/s^2
*/
const int    EL_TICKS_REV            = 1000 * 88;      // ticks
const int    EL_MAX_MOTOR_TICKS_SEC  = 46080;          // ticks/s
const int    EL_DEFAULT_MOTOR_ACCEL  = 11691;          // ticks/s^2
const double EL_MAX_VEL              = 1.29590696961;  // rad/s
const double EL_DEFAULT_ACCEL        = 0.328776397843; // rad/s^2

#endif /* __POINT_PARAM_H__ */
