#ifndef INCserialRS232h
#define INCserialRS232h
/*****************************************************************************
 *       $Id: serialRS232.h,v 1.2 1996/09/09 17:37:45 patrick Exp $
 * $Revision: 1.2 $
 *     $Date: 1996/09/09 17:37:45 $
 *   $Author: patrick $
 *    $State: Exp $
 *   $Locker:  $
 *
 *
 *                           ******************************
 *                           *      Copyright (C) 1995    *   
 *                           * Carnegie Mellon University *
 *                           *      All Rights Reserved   *
 *                           ******************************
 *
 * PROJECT:	Automated Loading System (ALS)
 * 
 * FILE:	serialRS232.h
 *
 * DESCRIPTION:	Prototypes and definitions for interfacing to an RS232 line.
 *
 * HISTORY:
 *
 * $Log: serialRS232.h,v $
 * Revision 1.2  1996/09/09  17:37:45  patrick
 * blanket commit
 *
 * Revision 1.1  1996/02/10  03:08:37  jorgen
 * Initial release.
 *
 *****************************************************************************/

#ifndef VXWORKS
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <sys/termios.h>
#include <sys/filio.h>
#include <sys/ttold.h>

#else
#include "vxWorks.h"
#include "ioLib.h"
#include "stdioLib.h"
#endif

/*****************************************************************************
 * DEFINES
 *****************************************************************************/

/*****************************************************************************
 * STRUCTS & TYPEDEFS
 *****************************************************************************/
typedef enum {
   parity_ODD, 
   parity_EVEN, 
   parity_NONE
} PARITY_ENUM;

/*****************************************************************************
 * EXPORTED VARIABLES
 *****************************************************************************/

/*****************************************************************************
 * EXPORTED ROUTINES
 *****************************************************************************/
extern "C" {
int           serialInit(char *portName, int speed, PARITY_ENUM parity);
int           serialNumChars(int fd);
void          serialFlushBuffer(int fd);
void          serialPutBuf(int fd, char *buf, int count);
int           serialGetBuf(int fd, char *buffer, int num_chars, int timeout);
void          raw(void);
int           kbhit(void);
unsigned char serialGetchar(int fd);
}
#endif INCserialRS232h

