/*
 * pass.c
 *
 * Mark Sibenac
 * 96-1-14
 * Field Robotics Center
 *
 * Makes serial communications pass transparently thru the two serial ports on
 * a vxworks computer board at 9600 baud.
 *
 * spawn pass from a telnet or rlogin window. kill process to return to normal
 * use.
 *
 *
 */

#include "pass.h"
#include "serial.h"

/*
 * port1_name = serial  port name (eg. "/tyCo/0")
 * port2_name = another port name (eg. "/tyCo/1")
 * 
 * This assumes 9600 baud.
 */
int pass (char *port1_name, char *port2_name)
{
  int fd0, fd1;
  char buff[2];

  buff[0] = buff[1] = 0;

  if ((fd0 = serialInit (port1_name, 9600)) == -1)
    return -1;
  if ((fd1 = serialInit (port2_name, 9600)) == -1)
    return -2;

  serialFlushBuffer (fd0);
  serialFlushBuffer (fd1);

  while (1)
    {
      if (serialNumChars (fd0))
	{
	  serialGetBuf(fd0, buff, 1, -1);
	  serialPutBuf(fd1, buff, 1);
	}

      if (serialNumChars (fd1))
	{
	  serialGetBuf(fd1, buff, 1, -1);
	  serialPutBuf(fd0, buff, 1);
	}
    }
}
