/*
   relay.h

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This is the interface level relay class. 
   
   Each relay channel is either opened=0 or closed=1.

*/

#ifndef __RELAY_H__
#define __RELAY_H__

#include "common/nomad_global.h"
#include "devices/devices.h"


class Crelay {
 private:
  int nChan; // actual relay channel on device

  Cdevices *pDevice;

  int nState; // Last set state of relay

 public:
  Crelay();

  static int Register (int num_chan, Cdevices *device_ptr);

  int GetRelay () {return nState;}
  int SetRelay (int state);

  static char *Name () { return "Crelay"; }
};

extern Crelay *relay; // array of relay's

#endif // __RELAY_H__







