/*
   encoder.cxx

   Mark Sibenac
   97-1-21
   Atacama Desert Trek
   Field Robotics Center

   This is the interface level encoder class.

*/

#include "encoder.h"
#include "robot/robot.h"
#include "logLib.h"

Cencoder *encoder; // array of encoders
static int nTotalChannelsAlloced = 0;
static int nTotalChannelsRegistered = 0;

#define ABS(x)  ((x)<0 ? (-(x)) : (x))

Cencoder::Cencoder()
{
  Dprintf(("Cencoder::Cencoder() creating new encoder object\n"));

  nTotalChannelsAlloced++;
  lRolls = 0;
  nLastEnc = 0;
}

int Cencoder::Register (int num_chan, Cdevices *device_ptr)
{
  ASSERT (num_chan >= 0);
    
  Dprintf(("Cencoder::Register() called with num_chan=%d, nTotalChannelsAlloced=%d, nTotalChannelsRegistered before call=%d\n", num_chan, nTotalChannelsAlloced, nTotalChannelsRegistered));

    for (int n=0; n < num_chan; n++)
      {  
	if (nTotalChannelsRegistered >= nTotalChannelsAlloced)
	  {
	    Dprintf(("Cencoder::Register() too many channels registered.\n"));
	    return (-1);
	  }

	encoder[nTotalChannelsRegistered].nPort = n;
	encoder[nTotalChannelsRegistered].pDevice = device_ptr;

	++nTotalChannelsRegistered;
      }

  return 0;
}

/*
   This gets the current encoder position from the device and returns a signed
   long int. No need to worry about roll overs. Just mod it.
*/
long Cencoder::GetEncoder()
{
  register int cur_enc = pDevice->GetEncoder(nPort);

  if ((cur_enc - nLastEnc) >= BIT_23)
    { // we flipped the 0 mark 
      lRolls -= BIT_24;
    }
  else if ((cur_enc - nLastEnc) <= -BIT_23)
    { // we flipped the 0 mark
      lRolls += BIT_24;
    }
     
  nLastEnc = cur_enc;
  return (long(cur_enc) + lRolls);
}

int Cencoder::PresetEncoder(int value)
{
  return (pDevice->PresetEncoder(nPort, value));
}

int Cencoder::SelectMode (int mode)
{
  return (pDevice->SelectMode(nPort, mode));
}




