/*
   dac.h

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This is the interface level dac class. 
   
   Interface to this with double-precision floating point numbers.

*/

#ifndef __DAC_H__
#define __DAC_H__

#include "common/nomad_global.h"
#include "devices/devices.h"


class Cdac {
 private:
  int nChan; // actual dac channel on device

  Cdevices *pDevice;

  double fValue; // Value last set

 public:
  Cdac();

  static int Register (int num_chan, Cdevices *device_ptr);

  double GetDAC ();
  int    SetDAC (double value); /* returns twos-comp digital value written */

  static char *Name () { return "Cdac"; }
};

extern Cdac *dac; // array of dacs

#endif // __DAC_H__







