/*
   adc.h

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This is the interface level adc class. 
   
   Interface to this with double-precision floating point numbers.

*/

#ifndef __ADC_H__
#define __ADC_H__

#include "common/nomad_global.h"
#include "devices/devices.h"


class Cadc {
 private:
  int nChan; // actual adc channel on device

  Cdevices *pDevice;

  double fValue; // Value last read

 public:
  Cadc();

  static int Register (int num_chan, Cdevices *device_ptr);

  double GetADC ();

  static char *Name () { return "Cadc"; }
};

extern Cadc *adc; // array of adcs

#endif // __ADC_H__







