/* 
 * vmio22_cwrap.cxx
 *
 * VME ADC Library C Wrapper File so routines can be called from VxWorks Shell
 * VMIO-22 Board to be used on VMIO-10
 *
 * 96-5-22
 * Mark Sibenac
 * Field Robotics Center
 * Lunar Rover Terrestrial Prototype
 *
 * These are the c wrapper functions to access the Vmio22 class.
*/

#include "common/nomad_global.h"
#include "vmio22.h"
#include "vmio22_cwrap.h"
#include "scopeprobe.h"
#include "taskLib.h"
#include "sysLib.h"

Cvmio22 *adc1;
Cvmio22 *adc0;

int initADC0()
{
  Dprintf(("Dprintf is working (ten=%d)\n", 10));

  adc0 = new Cvmio22(vmioAddress, 0, SINGLE_ENDED);

  return int(adc0);
}

int get0I(int nChannel)
{
  int nVal;

  nVal = adc0->GetADCI(nChannel);
  printf("adc0::nChannel = %d ===> %d twos-comp\n", nChannel, nVal);

  return nVal;
}

double get0F(int nChannel)
{
  double fVal;

  fVal = adc0->GetADCF(nChannel);
  printf("adc0::nChannel = %d ===> %f Volts\n", nChannel, fVal);

  return fVal;
}

int get0All ()
{
  for (int n=0; n<16; n++)
    {
      printf("adc0(%d) ===> %d twos-comp\n", n, adc0->GetADCI(n));
    }
  printf("\n");

  return 0;
}

int initADC1()
{

  adc1 = new Cvmio22(vmioAddress, 1, SINGLE_ENDED);
  
  return int(adc1);
}

int get1I(int nChannel)
{
  int nVal;

  nVal = adc1->GetADCI(nChannel);
  printf("adc1::nChannel = %d ===> %d twos-comp\n", nChannel, nVal);

  return nVal;
}

double get1F(int nChannel)
{
  double fVal;

  fVal = adc1->GetADCF(nChannel);
  printf("adc1::nChannel = %d ===> %f Volts\n", nChannel, fVal);

  return fVal;
}

int get1Scope (int freq)
{
  double fVal[16];
  char name[20];
  int n;

  initADC1();

  if ((freq < 0) || (freq > sysClkRateGet()))
    {
      printf("freq = %d must be between 0 and %d\n", freq, sysClkRateGet());
      return -1;
    }

  for (n=0; n<16; n++)
    {
      sprintf(name, "adc1:chan%d", n);
      ScopeInstallSignal(name, "volt", &fVal[n], "double", 0);
    }

  ScopeChangeSampleRate(double(freq), 0);

  while(1)
    {
      for(n=0; n<16; n++)
	{
	  fVal[n] = adc1->GetADCF(n);
	}
      ScopeCollectSignals(0);
      taskDelay(sysClkRateGet()/freq);
    }

  return 0;
}

int get1All ()
{
  for (int n=0; n<16; n++)
    {
      printf("adc1(%d) ===> %d twos-comp\n", n, adc1->GetADCI(n));
    }
  printf("\n");

  return 0;
}

