/*
  triwg.h
  
  Mark Sibenac
  96-6-7
  Field Robotics Center
  Lunar Rover Terrestrial Prototype
  TRIWG control of Ambler Amps.

  Using VADM10 with 64 Pin connector module and interfaced to a DB-15

  Left Command  - AO0, DB1, c9, P17, White
  Right Command - A02, DB13, c10, P19, Brown
  Command Ground- OGND, DB3, a7, P14, Orange
  Enable        - R0b, DB7, c2, P3, Black
  Digital Ground- R0c, DB8, c3, P5, Red
  
  call initTriwg() to initialize things to a known state.
  */

#ifndef __TRIWG_H__
#define __TRIWG_H__

extern "C" {

  void initTriwg(void);

  void enableAmps(void);
  void disableAmps(void);
  
  int forwardPercent(int percent); // -100 --> +100, backward-->forward
  int turnPercent(int percent);	// -100 --> +100, left-->right

  void updateSpeed (void);

  void menu (void);
  void changeJog (void);

  void serialJoy(void);
  void testSerialJoy(void);

  void goJoy(void);
}

#endif
