/*
   gui_mess.h

   Mark Sibenac
   97-2-18
   Atacama Desert Trek Robot

   These are the command number and message number definitions. These are
   used by the GUI and the real-time system.

   There are some definitions for the 8 motors, values of a button, and some
   global messages like GUI_STARTUP and UPDATE_ALL_FIELDS.

*/

#ifndef __GUI_MESS_H__
#define __GUI_MESS_H__

#define GUI_STARTUP		10
#define UPDATE_ALL_FIELDS	11

#define DRIVE_SYS_SPEED		100
#define DRIVE_SYS_RESET		101
#define DRIVE_SYS_ANGLE		102
#define DRIVE_SYS_STATE		103
#define DRIVE_SYS_LIMP		0
#define DRIVE_SYS_STOP		1
#define DRIVE_SYS_GO		2

#define AMP_RESET		200
#define AMP_STATUS		201
#define AMP_DISABLE		0
#define AMP_ENABLE              1
#define AMP_FAULT		202
#define AMP_ENABLED		203
#define AMP_TEMPERATURE		204 
#define AMP_MAXCOMMAND		205
#define AMP_POSITION		206
#define AMP_ANGLE		207

#define PID_KP			300
#define PID_KI			301
#define PID_KD			302
#define PID_ILIMIT		303
#define PID_MAXPOSERR		304

#define TRAJ_RESET		400
#define TRAJ_TARGETPOS		401
#define TRAJ_ACCELERATION	402
#define TRAJ_MAXVELOCITY	403
#define TRAJ_STATUS		404
#define TRAJ_DISABLE		0
#define TRAJ_ENABLE		1

#define DRIVE_VELOCITY		500
#define DRIVE_STATE		501
#define DRIVE_INHIBITED		0
#define DRIVE_SERVOING		1
#define DRIVE_OVERCURRENT	2
#define DRIVE_OVERTEMP		3
#define DRIVE_SERVOERROR	4

#define GPS_HILL_LAT		600
#define GPS_HILL_LONG		601
#define GPS_HILL_ALT		602
#define GPS_ROVER_LAT		603
#define GPS_ROVER_LONG		604
#define GPS_ROVER_ALT		605

#ifndef __MOTOR_ENUMS__
#define __MOTOR_ENUMS__
#define MOTOR_DRIVE_FL		0
#define MOTOR_DRIVE_FR		1
#define MOTOR_DRIVE_BL		2
#define MOTOR_DRIVE_BR		3
#define MOTOR_STEER_L		4
#define MOTOR_STEER_R		5
#define MOTOR_POINT_AZIMUTH	6
#define MOTOR_POINT_ELEVATION	7
#endif /* __MOTOR_ENUMS__ */

#define BUTTON_UP		0
#define BUTTON_DOWN		1

#endif /* __GUI_MESS_H__ */
