/* 
   vmio22_cwrap.h
   
   VME ADC Library Header File
   VMIO-22 Board to be used on VMIO-10

   96-12-19
   Mark Sibenac
   Field Robotics Center
   Lunar Rover Terrestrial Prototype

   These are the c wrapper functions to access the cVmio22 class.
*/

#ifndef __VMIO22_CWARP_H__
#define __VMIO22_CWRAP_H__

#include "common/nomad_global.h"
#include "vmio22.h"

const char *vmioAddress = (char *)0x1800;

extern Cvmio22 *adc0;
extern Cvmio22 *adc1;

extern "C"
{
  int initADC0();
  int get0I(int nChannel);
  double get0F(int nChannel);
  get0All ();

  int initADC1();
  int get1I(int nChannel);
  double get1F(int nChannel);
  get1All ();
  int get1Scope (int freq);

}

#endif
