/*
   pid_drive.cxx

   Mark Sibenac
   97-1-14
   Atacama Desert Trek
   Field Robotics Center

   This is the PID controller for the drive wheels. This does a servo loop
   around velocities and generates a current command.

*/

#include "pidDrive.h"
#include "devices/vmio/vmio28.h"

extern Cvmio28 *encoders;

CpidDrive::CpidDrive (int EncoderNum)
{
  if ((EncoderNum < 1) || (EncoderNum > 3))
    {
      Dprintf(("CpidDrive::CpidDrive() EncoderNum = %d is illegal\n", 
	       EncoderNum));
      exit(-1);
    }

  nEncoderNum = EncoderNum;
}

int CpidDrive::GetPosition()
{
  static int lastPos = 0;
  register int curPos;
  register int newPos;

  curPos = encoders->GetCounter(nEncoderNum);
  newPos = curPos - lastPos;
  lastPos = curPos;
  
  return newPos;
}
