/*
  nomad_types.h

  96-12-18
  Mark Sibenac
  Field Robotics Center
*/

#ifndef __NOMAD_TYPES_H__
#define __NOMAD_TYPES_H__

typedef volatile short int *WordRegister;
typedef volatile char *ByteRegister;

typedef short int Word;
typedef char Byte;

class Cdevices;

typedef enum {INHIBITED, SERVOING, OVERCURRENT, OVERTEMP, SERVO_ERROR} motor_state_t;

typedef enum {CASE1_ZONE1, CASE1_ZONE2, CASE1_ZONE3, CASE1_ZONE4, CASE2_ZONE1,
	      CASE2_ZONE2, CASE2_ZONE3, IDLE} Traj_Stat_t;

typedef enum {ROBOT_LIMP, ROBOT_STOP, ROBOT_GO} robot_state_t;

typedef int boolean;

typedef unsigned char uchar;

typedef struct {
  unsigned msec;          /* milliseconds in week */
  uchar    week;          /* week after Jan 1, 1997 */
} nomad_time_t, *nomad_time_ptr;

#ifndef __MOTOR_ENUMS__
#define __MOTOR_ENUMS__
typedef enum {
MOTOR_DRIVE_FL		= 0,
MOTOR_DRIVE_FR		= 1,
MOTOR_DRIVE_BL		= 2,
MOTOR_DRIVE_BR		= 3,
MOTOR_STEER_L		= 4,
MOTOR_STEER_R		= 5,
MOTOR_POINT_AZIMUTH	= 6,
MOTOR_POINT_ELEVATION	= 7
} MOTOR_t;
#endif /* __MOTOR_ENUMS__ */

#endif // __NOMAD_TYPES_H
