/* p_gui_consumer.c \- A consumer of data of type p_gui

   This file is derived from code automatically generated by nddsgen.

   modification history
   ------------ -------
   19a,29aug95,gpc Mofified for version 1.9
   RTI,29oct94,sas Changed names of some parameters.
   RTI,30may94,sas cleanup.
   RTI,02apr94,gpc Auto-generated code template written.
 */

static char copyright_rti[] = 
"(c) Copyright, Real-Time Innovations, Inc., 1994.  All rights reserved.";

/*
DESCRIPTION:
Example consumer of type p_gui automatically generated by 'nddsgen'
To test them follow these steps:

(1) Compile this file and the example consumer.

(2) Start NDDS with nddsStartDaemon -d <domain> on the machines where
the test will be run. For more details see the man page on nddsStartDaemon.

(3) Make sure your environment variable NDDS_PEER_HOSTS is set to at least
contain the machines where the test will be run.

(4) Start the producer on the same domain used for NDDS with the command
sun4/p_gui_producer  <domain>

(5) Start the consumer on the same domain used for NDDS with the command
sun4/p_gui_producer  <domain>

--------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include "NDDS.h"
#include "p_gui.h"

NDDSObjectInstance p_guiCallback(NDDSUpdateInfo updateInfo)
{
    double now;
    p_gui item = (p_gui)updateInfo->instance;

    now = NddsUtilityTimeGet();

#if 0
    /* Remove the #if...#endif statements to print extensive status */
    printf("[p_gui callback:] update packet arrived! "
	   "for \"%s\" of type \"%s\" STATUS: %s parameter is (%p)\n"
	   "data produced at time %f, received at %f, now is %f difference "
	   "is %f\n",
	   updateInfo->name, updateInfo->type, 
	   nddsUpdateStatus[updateInfo->updateStatus],
	   updateInfo->callBackRtnParam,
	   updateInfo->remoteTimeWhenProduced, 
	   updateInfo->localTimeWhenReceived, now,
	   now - updateInfo->remoteTimeWhenProduced);
#endif /* 0 */

    p_guiPrint(item);

    return updateInfo->instance;
}


void consumerMain(int argc, char *argv[])
{
    int nddsDomain = 0;
    int us_per_second = 1000000;
    NDDSConsumer itemConsumer;
    p_gui item1 = NULL;
    float deadline = 10.0f;
    float min_separation = 0.0f;

    if (argc >=2) {
	nddsDomain = atoi(argv[1]);
    }

    NddsInit(nddsDomain);
    NddsVerbositySet(1);

    p_guiNddsRegister();

    itemConsumer = NddsConsumerCreate("Consumer", NDDS_IMMEDIATE,
				      deadline, min_separation);

		
    /* The following alloc. is required for strings and custom structures */
    {
	item1 = (p_gui)calloc(1, sizeof(*item1));

	/* Allocate strings and custom structures here */
    }

    /* Ensure that item1 is either allocated or is NULL */
    NddsConsumerSubscriptionAdd(itemConsumer, "p_gui",
				"Example p_gui", item1,
				p_guiCallback, NULL);

    while (1) {
	/* NddsConsumerPoll(itemConsumer);	Only needed if NDDS_POLLED */

	/* We sleep only to kill time.  Nothing need be done here 
	   for an NDDS_IMMEDIATE consumer. */
	printf("Sleeping for %f sec...\n", deadline);
	NddsUtilitySleep((unsigned int)us_per_second*deadline);
    }
}

#ifndef RTS_VXWORKS
void main(int argc, char *argv[])
{
    consumerMain(argc, argv);
}
#endif


