/*
   pointsys.h

   Mark Sibenac
   97-2-25
   Field Robotics Center
   Atacama Desert Trek

   This modules is the mother controller over the azimuth and elevation
   motors. The actual pointing transforms exist in this class.

*/

#ifndef __POINTSYS_H__
#define __POINTSYS_H__

#include "common/nomad_global.h"
#include "semLib.h"
#include "point.h"

#define PRIORITY_PSPID 81

class Cpointsys {
 private:
  
  SEM_ID     m_semServo;        // semaphore to signal updating Servos

  int        m_point_time_preset; // point update sleep length
  int        m_point_timer;     // countdown timer for point update

  double     m_antPos[3];       // Antenna position (now [0,0,0])
  double     m_roverPos[3];     // Rover position   (now [1000,0,0])
  double     m_stationPos[3];   // Station position (now [0,0,0])
  double     m_roverAng[3];     // Rover attitude (now [yaw,pitch,roll])
  double     m_antAng[3];       // Output         (now [yaw,pitch])

  int        Transform     ();  // Perform transformation equations

 protected:

 public:

  Cpointsys                ();  // Constructor
 ~Cpointsys                ();  // Destructor

  int        Init          ();  // Initialization function

  int        UpdateServos  ();  // updates the 2 servo controllers, Transform
  int        SetUpdateFreq (int pid_freq, int traj_freq, int point_freq);
  SEM_ID     GetSemServo   () {return m_semServo;}

  Cpoint    *GetPointPtr   (int point_num); // point_num := [5,6]
  
  Cpoint    *pAzimuth;     // pointer to azimuth point object
  Cpoint    *pElevation;   // pointer to elevation point object
};

extern Cpointsys *pointsys; // defined in robot.cxx

#endif // __POINTSYS_H__











