/*
   point.h

   Mark Sibenac
   97-2-4
   Atacama Desert Trek
   Field Robotics Center

   This module handles the two pointing system motors (azimuth, pitch).

   Each motor can be in one of the following states: {INHIBITED, SERVOING,
   OVERCURRENT, OVERTEMP, ERROR}

*/

#ifndef __POINT_H__
#define __POINT_H__

#include "common/nomad_global.h"
#include "components/amps/amps.h"
#include "components/pid/pid.h"
#include "components/traject/traject.h"

class Cpoint {
 private:
  motor_state_t m_state; // motor state
  int           m_axis_number;
  double        m_fTargetAngle; // in radians [-PI,PI]

  int           m_traject_time_preset;  // trajectory update sleep length
  int           m_traject_timer; // countdown timer for trajectory update
  int           m_traject_current_des_pos; // since last trajectory update
  int           m_traject_current_des_vel; // since last trajectory update

  double        m_fDesVel; // Desired Velocity in rad/s
  double        m_fCurrentVel; // Current Velocity at this point in time rad/s
  double        m_fAccel;  // Acceleration in rad/s/s

 public:
  Cpoint (int axis_number, Camps *amp_in);
 ~Cpoint ();

  int           Init          (double Kp, double Ki, double Kd, double I_limit,
			       double MaxPosErr, double MaxAmp, double Accel);
  int           UpdateServo   ();
  int           ChangeState   (motor_state_t state);
  motor_state_t GetState      () {return m_state;}
  int           SetTarget     (double fTargetAngle);
  double        GetTarget     () {return m_fTargetAngle;}
  int           SetUpdateFreq (int pid_freq, int trajectory_freq); //Freq in Hz

  Camps        *m_amp; // Angular 400 ticks/rev motor shaft
  Cpid          m_pid; // PID controller
  Ctraject      m_trajectory; // Trapezoidal trajectory generator
};

#endif // __POINT_H__

