/*

   serial.h

   97-2-12
   Mark Sibenac
   Field Robotics Center
   Atacama Desert Trek

   This is the serial interface to the VxWorks tyCo driver.
*/

#ifndef __SERIAL_H__
#define __SERIAL_H__

#include "common/nomad_global.h"

extern "C" {

  int  serialInit        (char *portName, int speed);
  int  serialNumChars    (int fd);
  void serialFlushBuffer (int fd);
  void serialPutBuf      (int fd, char *buf, int count);
  int  serialGetBuf      (int fd, char *buffer, int num_chars, int timeout);
  char serialGetchar     (int fd);
}

#endif /* __SERIAL_H__ */
