/*
   vmio28_cwrap.cxx

   VME I/O Class File C wrappers
   VMIO-28 Piggy Back for a VMIO-10 card (opto-isolated encoder input)

   97-1-8
   Mark Sibenac
   Field Robotics Center
   Lunar Rover Terrestrial Prototype

   nVmioBay = (0->P5,P6,P9,P10;01-16,   1->P3,P4,P7,P8;17-32)
   pBoardVmeAddress (VMIO10) = I/O address on VMEbus (not short space)
*/

#include "vmio28_cwrap.h"
#include "scopeprobe.h"
#include "taskLib.h"
#include "sysLib.h"

Cvmio28 *vmio28;

int init28 ()
{
  vmio28 = new Cvmio28(vmioAddress, vmioBay);

  return vmio28->SelectMode(1,1);
}

int selectMode12 (Byte cMode12_in)
{
  return vmio28->SelectMode(1, cMode12_in);
}

int counterReset ()
{
  return vmio28->CounterReset();
}

int presetCounter (int nCounter, int nCount)
{
  return vmio28->PresetEncoder(nCounter, nCount);
}

int getCounter (int nCounter)
{
  int nResult;
  nResult = vmio28->GetEncoder(nCounter);

  printf("Counter %d = %d\n", nCounter, nResult);

  return nResult;
}

int vmio28Scope (int freq)
{
  int nVal[4];
  char name[20];
  int n;

  init28();

  if ((freq < 0) || (freq > sysClkRateGet()))
    {
      printf("freq = %d must be between 0 and %d\n", freq, sysClkRateGet());
      return -1;
    }

  for (n=0; n<4; n++)
    {
      sprintf(name, "vmio28:counter%d", n+1);
      ScopeInstallSignal(name, "ticks", &nVal[n], "int", 0);
    }

  ScopeChangeSampleRate(float(freq), 0);

  while(1)
    {
      for(n=0; n<4; n++)
	{
	  nVal[n] = vmio28->GetEncoder(n+1);
	}
      ScopeCollectSignals(0);
      taskDelay(sysClkRateGet()/freq);
    }

  return 0;
}
